s              /                                        bp2318      Burster Resistomat Type 2318                        Instrument Name: Burster Resistomat Type 2318

  Description:   This instrument module provides
                 RS232 support for Resistomat
                 Type 2318 from Burster.

  Functions and Classes:

  (1) Initialize :
      Initialize the instrument and sets to
      default configuration

  (2) Configure:
      Configures the instrument by setting the
      range, correction, calibration, measurement
      mode

  (3) Measure
      Starts measurement
      Reads measurement value
      Stops measurement

  (4) Comparator:
      Sets comparator limits and state
      Gets comparator limits

  (5) System:
      Sets the group and user address
      Gets the group and user address
      Reads the system error
      Resets the instrument
      Reads the instrument ID-String
      Controls the keyboard
      Controls the display test
      Sends a SCPI-Message
      Receives a SCPI-Message

  (6) Close :
      Takes the instrument off-line.
      *********    $     Panel Name:    Initialize

 Description:   Initializes the instrument in
                following ways:

                - opening a RS232-Port with user
                  specified baud-rate and time-out

                - sets the instrument to a default
                  configuration          Class Name:    Configure

 Description:   Class of functions for setting the
                following types of parameters:

                - Set the configure
                - Get the configure    ?     Panel Name:    Set Configure

 Description:   Initializes the instrument in
                following ways:

                - Sets the range of the instrument
                - Switches the Auto-Zero function
                  ON/OFF
                - Selects the one of the three
                  possible temperature coeffic-
                  ients
                - Selects the load to be measured
                  (mainly ohmic or mainly
                  inductive resistance)
                - Selects the one of the three
                  possible 20mV limits.         Panel Name:    Get Configure

 Description:   Initialize the instrument in
                following ways:

                - Gets the range of the instrument
                - Gets the Auto-Zero state
                - Gets the one of the three
                  possible temperature coeffic-
                  ients
                - Gets the load to be measured
                  (mainly ohmic or mainly
                  inductive resistance)
                - Gets the one of the three
                  possible 20mV limits.          Class Name:    Measure

 Description:   Class of functions for setting the
                following types of parameters:

                - Start the measurement
                - Read a value from the instrument
                - Stop the measurement
     G     Panel Name:    Measure Start

 Description:   Start the measurement
          Panel Name:    Measure Read

 Description:   Reads the measuring values from
                the instrument while a measurement
                is done     E     Panel Name:    Measure Stop

 Description:   Stops the measurement           Class Name:  Comparator

   Description: Class of functions for setting the
                following types of parameters:

                - Set the comparator limits and
                  the comparator state

                - Get the comparator limits     v     Panel Name:    Comparator Limit

 Description:   Set the comparator limits and the
                comparator state     w     Panel Name:    Get Comparator Data

 Description:   Gets the comparator limits and
                comparator state
           Class Name:  System

   Description: Class of functions for setting the
                follow parameters:

                - Sets the group and user address
                - Gets the group and user address
                - Read the system error
                - Reset the instrument
                - Read the instrument ID-String
                - Control the keyboard
                - Control the display test
                - Send a SCPI-Message
                - Recieve a SCPI-Message
     v     Panel Name:    Set Address

 Description:   Sets the group and user address in
                the internal EEPROM
     y     Panel Name:    Get Address

 Description:   Gets the group and user address
                from the internal EEPROM

     a     Panel Name:   System Error

 Description:  Reads the system error of the
               device     U     Panel Name:   System Keybroad

 Description:  Controls the keybroad of the device
    K     Panel Name:   Reset device

 Description:  Resets the instrument to the
               default states

               - Auto Range ON
               - Load Ohmic
               - 20mV Limit OFF
               - Auto Zero OFF
               - Temp. Compensation OFF
               - Comparator OFF
               - Local Lockout
     f     Panel Name:   Read ID-String

 Description:  Reads the ID-String from the
               instrument     g     Panel Name:   Display Test

 Description:  Activates or deactivates the
               display test
     u     Panel Name:   Send a SCPI-Message

 Description:  Sends a SCPI-Message to a
               slave and receive a ACK          Panel Name:   Receive a SCPI-Message

 Description:  Sends "Query form" from SCPI-
               Message and receive a answers
               => Polling     k     Panel Name :  Close an instrument

 Description:  Closes a instrument on the RS232-
               Port
         Control Name:   COM-Port

 Description:    Specifies the COM-Port to be
                 used to communicate with the
                 instrument.

 Variable Type:  Integer

 Valid Values:   1 - COM1   (=> Adress 0x3f8 IRQ4)
                 2 - COM2   (=> Adress 0x2f8 IRQ3)
                 3 - COM3   (=> Adress 0x3e8 IRQ4)
                 4 - COM4   (=> Adress 0x2e8 IRQ3)

 Default:        1         Control Name:   Baud Rate

 Description:    Specifies the baud rate of the
                 RS232-Port to communicate with
                 the instrument. This value must
                 correspond to the current
                 internal setting of the
                 instrument.

 Variable Type:  Integer

 Valid Values:   1200,2400,4800,9600 or 19200 baud

 Default:        9600    *     Control Name:   Time-out (seconds)

 Description:    Specifies  the time-out limit for
                 I/O operations.
                 A  value  of  0.0  will  disable
                 time-out altogether.

 Variable Type:  Double

 Valid Range:    0.060 to 100.0 seconds

 Default:        1.0    q     Control Name:   Bcc-Check

 Description:    This parameter switches the block
                 check function of the driver ON
                 or OFF.
                 This value must correspond to the
                 current internal setting of the
                 instrument.

 Variable Type:  Integer

 Valid Values:   0 = OFF, 1 = ON

 Default:        0 = OFF    |     Control Name:  Group Address

 Description:   Specifies the group address on the
                RS232 (RS485) to be used to
                communicate with the instrument.
                This value must correspond to the
                current internal group address
                from the instrument.


 Variable Type: Integer

 Valid Range:   0 to 15

 Default:       0    w     Control Name:  User Adress

 Description:   Specifies the user address on the
                RS232 (RS485) to be used to
                communicate with the instrument.
                This value must correspond to the
                current internal user address
                from the instrument.

 Variable Type: Integer

 Valid Range:   0 to 15

 Default:       0         Control Name:  Reset

 Description:   Specifies if the instrument is to
                be reset to its power-on settings
                during the initialization
                procedure.

 Variable Type: Integer

 Valid Range:   1 = Yes
                0 = No

 Default Value: 1 - Yes

 NOTE: If you do not want the instrument reset
       set this control to No while initializing
       the instrument.    -     Control Name:  Instrument ID

 Description:   Returns an Instrument ID that is
                used in all subsequent function
                calls to select the instrument at
                the RS232-Port and the address
                specified.

                If more than one instrument of the
                same type is used, this value will
                be used to differentiate between
                them. The first instrument
                initialized will be assigned an
                Instrument ID of 1.

 Variable Type: Integer         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   COM-Port is out of range
       -2   Baud Rate is out of range
       -3   Time-out is out of range
       -4   Block Check parameter is out of range
       -5   Group Address is out of range
       -6   User Address is out of range
       -7   Reset Device is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   The instrument sends NAK
      301   The instrument sends EOT

      9           COM-Port                          )            Baud Rate                              `    Time-out (seconds)                           Block Check                       `       `    Group Address                            `    User Address                      c           Reset Device                      !      `    Instrument ID                     #;     `    Error                                          1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8              41200 1200 2400 2400 4800 4800 9600 9600 19200 19200    1.0    On 1 Off 0    0    0    Reset Device 1 Don't Reset 0    	            	                 Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  15          Control Name:  Resistance Load

 Description:   Selects the load to be measured.
                Mainly ohmic or mainly inductive
                resistance.

 Variable Type: Integer

 Valid Range:   0 = Ohmic
                1 = Inductive          Control Name:  Auto Zero

 Description:   Switches the Auto Zero function
                of the instrument ON/OFF.

 Variable Type: Integer

 Valid Range:   0 = Auto Zero OFF
                1 = Auto Zero ON
         Control Name:  Range

 Description:   Specifices the range of the
                instrument .

 Variable Type: Integer

 Valid Range:   0 = Auto Range
                1 = 20  mOhm
                2 = 200 mOhm
                3 = 2   Ohm
                4 = 20  Ohm
                5 = 200 Ohm
                6 = 2   KOhm
                7 = 20  KOhm
                8 = 200 KOhm
          Control Name:  20 mV Limit

 Description:   Selects the range of the 20 mV
                Limit.

 Variable Type: Integer

 Valid Range:   0 = NONE
                1 = 20 mV,1 A
                2 = 20 mV,10 mA
                3 = 20 mV,100 mA    <     Control Name:  Temp.Comp

 Description:   Selects the temperature coeff-
                itient for the temperature
                compensation.

 Variable Type: Integer

 Valid Range:   0 = NONE
                1 = CU/AL (3930 ppm/k)
                2 = MS63  (1500 ppm/k)
                3 = MS80  (1600 ppm/k)         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID is out of range
       -2   Resistance load is out of range
       -3   Auto Zero is out of range
       -4   Range parameter is out of range
       -5   20mV Limit parameter is out of range
       -6   Temp.Comp. parameter is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   The instrument sends NAK
      301   The instrument sends EOT    )        `    Instrument ID                     )            Resistance Load                   * G          Auto Zero                         + } X          Range                             -Q }           Limit 20mV                        .O }a          Temp.Comp.                        /     `    Error                              1    Inductive 1 Ohmic 0    On 1 Off 0            	   UAuto 0 20 mOhm 1 200 mOhm 2 2 Ohm 3 20 Ohm 4 200 Ohm 5 2 KOhm 6 20 KOhm 7 200 KOhm 8               *None 0 20mV,1A 1 20mV,100mA 2 20mV,10mA 3               None 0 CU/Al 1 MS63 2 MS80 3    	                 Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  15          Control Name:  Resistance Load

 Description:   Displays the load to be measured.
                Mainly ohmic or mainly inductive
                resistance.

 Variable Type: Integer

 Resistance Load:   0 = Ohmic
                    1 = Inductive

          Control Name:  Auto Zero

 Description:   Displays the state of Auto-Zero
                function.


 Variable Type: Integer

 Auto Zero:   0 = Auto Zero OFF
              1 = Auto Zero ON
    H     Control Name:  Range

 Description:   Displays the range of the
                instrument .

 Variable Type: Integer

 Range:   0 = Auto Range
          1 = 20  mOhm
          2 = 200 mOhm
          3 = 2   Ohm
          4 = 20  Ohm
          5 = 200 Ohm
          6 = 2   KOhm
          7 = 20  KOhm
          8 = 200 KOhm
          Control Name:  20 mV Limit

 Description:   Displays the range of the 20 mV
                Limit.

 Variable Type: Integer

 20mV Limit:   0 = NONE
               1 = 20 mV,1 A
               2 = 20 mV,10 mA
               3 = 20 mV,100 mA
    9     Control Name:  Temp.Comp

 Description:   Displays the temperature coeff-
                itient of the temperature
                compensation.

 Variable Type: Integer

 Temp.Compe:   0 = NONE
               1 = CU/AL (3930 ppm/k)
               2 = MS63  (1500 ppm/k)
               3 = MS80  (1600 ppm/k)
    2     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   The instrument sends NAK
      301   The instrument sends EOT
      304   Unknown parameter from instrument    4        `    Instrument ID                     5       `    Resistance Load                   6 +     `    Auto Zero                         7       `    Range                             8       `    Limit 20mV                        9 +     `    Temp.Comp                         ;7     `    Error                              1    	            	            	            	            	            	                 Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  15         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   The instrument sends NAK
      301   The instrument sends EOT
    ?1        `    Instrument ID                     @     `    Error                              1    	                 Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  15          Control Name:  Measuring Value

 Description:   Displays the measuring value.
                The unit is Ohm

 Variable Type: Double

     _     Control Name:  Unit

 Description:   Displays the measuring unit.


 Variable Type: String

    E     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID is out of range


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   The instrument sends NAK
      301   The instrument sends EOT
      302   Measuring isn't started
      303   Overrange





    B        `    Instrument ID                     C m     `    Measuring Value                   D! m2    `    Unit                              D     `    Error                              1    	           	            	                 Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  15    
     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID is out of range


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   The instrument sends NAK
      301   The instrument sends EOT




    G        `    Instrument ID                     H     `    Error                              1    	                 Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  15          Control Name:  Comparator State

 Description:   This parameter activates or
                deactivates the comparator
                function.

 Variable Type: Integer

 Valid Range:   0 = OFF
                1 = ON

 Default:       1 = ON
          Control Name:  Lower Limit

 Description:   Accepts the lower limit for the
                comparator function. The unit is
                "Ohm".

 Variable Type: Double

 Valid Range:   0.0 to  200000.00 (Ohm)          Control Name:  Upper Limit

 Description:   Accepts the upper limit for the
                comparator function. The unit is
                "Ohm".

 Variable Type: Double

 Valid Range:   0.0 to  200000.00 (Ohm)         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID is out of range
       -2   Comparator state is out of range
       -3   Lower limit is out of range
       -4   Upper limit is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   The instrument sends NAK
      301   The instrument sends EOT




    KJ        `    Instrument ID                     L5 -           Comparator State                  M3 -2    `    Lower Limit                       N -    `    Upper Limit                       N     `    Error                              1   On 1 Off 0    0    0    	                 Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  15          Control Name:  Comparator state

 Description:   Displays the comparator state.

 Variable Type: Integer

 Comparator state : 0 = OFF
                    1 = ON          Control Name:  Lower Limit

 Description:   Displays the lower comparator
                limit

 Variable Type: Double

 Unit : Ohm
          Control Name:  Upper Limit

 Description:   Displays the upper comparator
                limit

 Variable Type: Double

 Unit : Ohm    	     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   The instrument sends NAK
      301   The instrument sends EOT




    R        `    Instrument ID                     S       `    Comparator State                  TG +    `    Lower Limit                       T     `    Upper Limit                       Uf     `    Error                              1    	            	           	           	                 Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  15          Control Name:  Group Address

 Description:   Specifies the group address on the
                RS232 (RS485) to be used to
                communicate with the instrument.

 Variable Type: Integer

 Valid Range:   0 to 15

 Default:       0          Control Name:  User Address

 Description:   Specifies the user address on the
                RS232 (RS485) to be used to
                communicate with the instrument.

 Variable Type: Integer

 Valid Range:   0 to 15

 Default:       0    \     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID is out of range
       -2   Group address is out of range
       -3   User address is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   The instrument sends NAK
      301   The instrument sends EOT




    X        `    Instrument ID                     Y       `    Group Address                     Z 9     `    User Address                      [     `    Error                              1    0    0    	                 Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  15          Control Name:  Group Address

 Description:   Displays the group address on the
                RS232 (RS485) to be used to
                communicate with the instrument.

 Variable Type: Integer
          Control Name:  Group Address

 Description:   Displays the group address on the
                RS232 (RS485) to be used to
                communicate with the instrument.

 Variable Type: Integer
    	     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   The instrument sends NAK
      301   The instrument sends EOT




    ^        `    Instrument ID                     _       `    Group Address                     ` @     `    User Address                      ax     `    Error                              1    	            	            	                 Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  15          Control Name:  System Error

 Description:   Displays the SCPI system error


 Variable Type: String
                (see manual Resistomat Type 2318)
    	     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   The instrument sends NAK
      301   The instrument sends EOT




    d        `    Instrument ID                     eq }     `    System Error                      f     `    Error                              1    	            	                 Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  15          Control Name:  Keyboard

 Description:   This parameter locks the keyboard
                on the front panel of the
                instrument

 Variable Type: Integer

 Valid Range:   0  = Unlocked
                1  = Locked    8     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID is out of range
       -2   Keyboard parameter is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   The instrument sends NAK
      301   The instrument sends EOT




    h        `    Instrument ID                     i m           Keyboard                          j     `    Error                              1    Locked 1 Unlocked 0    	                 Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  15    	     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   The instrument sends NAK
      301   The instrument sends EOT




    m        `    Instrument ID                     n     `    Error                              1    	                 Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  15          Control Name:  ID-String

 Description:   Displays the ID-String from the
                instrument

 Variable Type: String (Lenght = 35)
    	     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   The instrument sends NAK
      301   The instrument sends EOT




    q7        `    Instrument ID                     r" }     `    ID-String                         r     `    Error                              1    	            	                 Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  15    	     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   The instrument sends NAK
      301   The instrument sends EOT




    u        `    Instrument ID                     vp     `    Error                              1    	                 Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  15          Control Name:  Send SCPI-Message

 Description:   This control is a string parameter
                You must input the SCPI-message
                without the LineFeed termination.

 Example      : ":SENS:CORR:STATE ON"

 Variable Type: String
    	     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   The instrument sends NAK
      301   The instrument sends EOT




    x        `    Instrument ID                     y      `    Send-SCPI-Message                 z     `    Error                              1        	                 Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  15         Control Name:  Send SCPI-Message

 Description:   This control is a string parameter
                You must input Query-Form from
                the SCPI-message without the
                Line Feed termination.

 Example      : ":SENS:CORR:STATE?"

 Variable Type: String          Control Name:  Answer from Slave

 Description:   This control return a string from
                the slave.

 Variable Type: String (Length => see the 2318
                        Manual SCPI-Commands)    	     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   The instrument sends NAK
      301   The instrument sends EOT




    }        `    Instrument ID                     ~      `    Send-SCPI-Message                  +    `    Instrument Answers                     `    Error                              1        	            	                 Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  15    -     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      221   Unable to close instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   The instrument sends NAK
      301   The instrument sends EOT

            `    Instrument ID                          `    Error                              1    	           ]         &b 	    K.    init                              X         2     K.    set_config                                 =q     K.    get_config                                 B)     K.    meas_start                                 F     K.    meas_read                                  J     K.    meas_stop                                  Q     K.    set_comp_limit                             Ww     K.    get_comp_limit                             ]     K.    set_address                                c     K.    get_address                                h$     K.    system_error                      p         l     K.    system_keyboard                            p     K.    reset                                       t     K.    read_id                                    x     K.    display_test                               |     K.    send_scpi                         z              K.    receive_scpi                                    K.    close                                                                       DInitialize                          Configure                            DSet Configure                        DGet Configure                       
Measure                              DMeasure Start                        DMeasure Read                         DMeasure Stop                        
Comparator                           DSet Comparator Limit                 DGet Comparator limit                System                               DSet Address                          DGet Address                          DSystem Error                         DSystem Keyboard                      DReset Device                         DRead ID-String                       DDisplay Test                         DSend a SCPI-Message                  DReceive a SCPI-Message               DClose                           